/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapIntBufferR;
import java.nio.IntBuffer;

class HeapIntBuffer
extends IntBuffer {
    HeapIntBuffer(int n, int n2) {
        super(-1, 0, n2, n, new int[n], 0);
    }

    HeapIntBuffer(int[] nArray, int n, int n2) {
        super(-1, n, n + n2, nArray.length, nArray, 0);
    }

    protected HeapIntBuffer(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, nArray, n5);
    }

    @Override
    public IntBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        return new HeapIntBuffer(this.hb, -1, 0, n3, n3, n2 + this.offset);
    }

    @Override
    public IntBuffer duplicate() {
        return new HeapIntBuffer(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new HeapIntBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    protected int ix(int n) {
        return n + this.offset;
    }

    @Override
    public int get() {
        return this.hb[this.ix(this.nextGetIndex())];
    }

    @Override
    public int get(int n) {
        return this.hb[this.ix(this.checkIndex(n))];
    }

    @Override
    public IntBuffer get(int[] nArray, int n, int n2) {
        HeapIntBuffer.checkBounds(n, n2, nArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.hb, this.ix(n3), nArray, n, n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public IntBuffer put(int n) {
        this.hb[this.ix((int)this.nextPutIndex())] = n;
        return this;
    }

    @Override
    public IntBuffer put(int n, int n2) {
        this.hb[this.ix((int)this.checkIndex((int)n))] = n2;
        return this;
    }

    @Override
    public IntBuffer put(int[] nArray, int n, int n2) {
        HeapIntBuffer.checkBounds(n, n2, nArray.length);
        int n3 = this.position();
        if (n2 > this.limit() - n3) {
            throw new BufferOverflowException();
        }
        System.arraycopy(nArray, n, this.hb, this.ix(n3), n2);
        this.position(n3 + n2);
        return this;
    }

    @Override
    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof HeapIntBuffer) {
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            HeapIntBuffer heapIntBuffer = (HeapIntBuffer)intBuffer;
            int n = this.position();
            int n2 = heapIntBuffer.position();
            int n3 = heapIntBuffer.limit() - n2;
            if (n3 > this.limit() - n) {
                throw new BufferOverflowException();
            }
            System.arraycopy(heapIntBuffer.hb, heapIntBuffer.ix(n2), this.hb, this.ix(n), n3);
            heapIntBuffer.position(n2 + n3);
            this.position(n + n3);
        } else if (intBuffer.isDirect()) {
            int n = intBuffer.remaining();
            int n4 = this.position();
            if (n > this.limit() - n4) {
                throw new BufferOverflowException();
            }
            intBuffer.get(this.hb, this.ix(n4), n);
            this.position(n4 + n);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    @Override
    public IntBuffer compact() {
        int n = this.position();
        int n2 = this.limit() - n;
        System.arraycopy(this.hb, this.ix(n), this.hb, this.ix(0), n2);
        this.position(n2);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

