/*
 * Decompiled with CFR 0.152.
 */
package labelprinter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import labelprinter.LabelPrinterService;
import labelprinter.PrintPreview;
import labelprinter.PrintSettings;
import labelprinter.PrintSettingsService;

public class LabelPrinterGui
extends JFrame {
    private final LabelPrinterService printer;
    private final PrintSettingsService settings;
    private File imageFile;
    private final PrintPreview printPreview;
    private final AbstractAction openAction;
    private JButton btnApply;
    private JButton btnClose;
    private JButton btnOpen;
    private JButton btnPrint;
    private ButtonGroup buttonGroup1;
    private JComboBox<String> cbPrinter;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSpinner numBottom;
    private JSpinner numCopy;
    private JSpinner numHeight;
    private JSpinner numLeft;
    private JSpinner numRight;
    private JSpinner numTop;
    private JSpinner numWitdth;
    private JRadioButton rRot0;
    private JRadioButton rRot270;
    private JRadioButton rRot90;

    public LabelPrinterGui(final PrintSettingsService settings, LabelPrinterService printer, File imageFile) {
        this.printer = printer;
        this.settings = settings;
        this.printPreview = new PrintPreview();
        this.printPreview.setPreferredSize(new Dimension(500, 500));
        this.setImage(imageFile);
        this.getContentPane().add((Component)this.printPreview, "Center");
        this.initComponents();
        this.openAction = new AbstractAction("Open File"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int result;
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileNameExtensionFilter("Image files", ImageIO.getReaderFileSuffixes()));
                String p = settings.getDefaultPath();
                if (p != null) {
                    fileChooser.setCurrentDirectory(new File(p));
                }
                if ((result = fileChooser.showOpenDialog(LabelPrinterGui.this)) == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    LabelPrinterGui.this.setImage(selectedFile);
                }
            }
        };
        this.btnOpen.setAction(this.openAction);
        this.btnOpen.getActionMap().put("open", this.openAction);
        this.btnOpen.getInputMap(2).put(KeyStroke.getKeyStroke(79, 2), "open");
        this.cbPrinter.removeAllItems();
        printer.getPrinters().forEach(this.cbPrinter::addItem);
        String printerName = settings.getDefaultPrinter();
        if (printerName != null) {
            this.cbPrinter.setSelectedItem(printerName);
        }
        this.applySettings(this.settings.getSettings((String)this.cbPrinter.getModel().getSelectedItem()));
        this.btnPrint.requestFocus();
        this.rootPane.registerKeyboardAction(x -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    public final void setImage(File f) {
        if (f != null) {
            this.setTitle("Almeva LabelPrinter - " + f.getPath());
            this.settings.setDefaultPath(f.getPath());
        } else {
            this.setTitle("Almeva LabelPrinter");
        }
        this.imageFile = f;
        this.printPreview.setImage(f);
        this.printPreview.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.cbPrinter = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.rRot0 = new JRadioButton();
        this.rRot90 = new JRadioButton();
        this.rRot270 = new JRadioButton();
        this.jLabel17 = new JLabel();
        this.numCopy = new JSpinner();
        this.btnPrint = new JButton();
        this.btnClose = new JButton();
        this.numWitdth = new JSpinner();
        this.numHeight = new JSpinner();
        this.numBottom = new JSpinner();
        this.numRight = new JSpinner();
        this.numTop = new JSpinner();
        this.numLeft = new JSpinner();
        this.btnApply = new JButton();
        this.jPanel1 = new JPanel();
        this.btnOpen = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel1.setText("Printer");
        this.cbPrinter.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPrinter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPrinterGui.this.cbPrinterActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Paper size");
        this.jLabel3.setText("Width");
        this.jLabel4.setText("mm");
        this.jLabel5.setText("Height");
        this.jLabel6.setText("mm");
        this.jLabel7.setText("Margins");
        this.jLabel8.setText("Left");
        this.jLabel9.setText("Top");
        this.jLabel10.setText("Right");
        this.jLabel11.setText("Bottom");
        this.jLabel12.setText("mm");
        this.jLabel13.setText("mm");
        this.jLabel14.setText("mm");
        this.jLabel15.setText("mm");
        this.jLabel16.setText("Orientation");
        this.buttonGroup1.add(this.rRot0);
        this.rRot0.setText("0\u00b0");
        this.buttonGroup1.add(this.rRot90);
        this.rRot90.setText("90\u00b0");
        this.buttonGroup1.add(this.rRot270);
        this.rRot270.setText("270\u00b0");
        this.jLabel17.setText("Copies");
        this.numCopy.setValue(1);
        this.btnPrint.setText("Print");
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPrinterGui.this.btnPrintActionPerformed(evt);
            }
        });
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPrinterGui.this.btnCloseActionPerformed(evt);
            }
        });
        this.btnApply.setText("Apply");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPrinterGui.this.btnApplyActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(20, 20, 20).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rRot270).addComponent(this.rRot90).addComponent(this.rRot0).addComponent(this.jLabel16).addComponent(this.jLabel7).addComponent(this.jLabel10).addComponent(this.jLabel9).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.numWitdth, -2, 75, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4))).addGap(53, 53, 53).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.numHeight, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6)))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.numCopy, -2, 68, -2)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numLeft, -2, 83, -2).addComponent(this.numTop, -2, 83, -2).addComponent(this.numRight, -2, 83, -2).addComponent(this.numBottom, GroupLayout.Alignment.TRAILING, -2, 83, -2))).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel12).addComponent(this.jLabel14).addComponent(this.jLabel15)))).addGap(0, 14, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPrinter, 0, -1, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnApply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPrint))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbPrinter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel6).addComponent(this.numWitdth, -2, -1, -2).addComponent(this.numHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.numLeft, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.numTop, -2, -1, -2).addComponent(this.jLabel13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jLabel14).addComponent(this.numRight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jLabel15).addComponent(this.numBottom, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rRot0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rRot90).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rRot270).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.numCopy, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPrint).addComponent(this.btnClose).addComponent(this.btnApply)).addContainerGap()));
        this.getContentPane().add((Component)this.jPanel2, "East");
        this.jPanel1.setPreferredSize(new Dimension(671, 25));
        this.btnOpen.setText("Open");
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabelPrinterGui.this.btnOpenActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnOpen).addGap(0, 599, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnOpen).addGap(0, 0, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "First");
        this.pack();
    }

    private void cbPrinterActionPerformed(ActionEvent evt) {
        String selectedPrinter = (String)this.cbPrinter.getModel().getSelectedItem();
        System.out.println("Printer changed " + selectedPrinter);
        if (selectedPrinter != null) {
            this.applySettings(this.settings.getSettings(selectedPrinter));
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        this.saveSettings();
        PrintSettings ps = this.getSettings();
        this.printPreview.setPrintSettings(ps);
        this.printPreview.repaint();
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        this.saveSettings();
        PrintSettings ps = this.getSettings();
        this.printPreview.setPrintSettings(ps);
        this.printPreview.repaint();
        try {
            this.printer.print(ps, this.imageFile, (Integer)this.numCopy.getValue());
        }
        catch (PrinterException ex) {
            Logger.getLogger(LabelPrinterGui.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
    }

    private void applySettings(PrintSettings s) {
        this.cbPrinter.getModel().setSelectedItem(s.printer);
        this.numWitdth.setValue(s.width);
        this.numHeight.setValue(s.height);
        this.numLeft.setValue(s.left);
        this.numTop.setValue(s.top);
        this.numRight.setValue(s.right);
        this.numBottom.setValue(s.bottom);
        if (s.orientation == 0) {
            this.rRot0.setSelected(true);
        }
        if (s.orientation == 90) {
            this.rRot90.setSelected(true);
        }
        if (s.orientation == 270) {
            this.rRot270.setSelected(true);
        }
        this.printPreview.setPrintSettings(s);
        this.printPreview.repaint();
    }

    private PrintSettings getSettings() {
        PrintSettings s = new PrintSettings();
        s.printer = (String)this.cbPrinter.getModel().getSelectedItem();
        s.width = (Integer)this.numWitdth.getValue();
        s.height = (Integer)this.numHeight.getValue();
        s.left = (Integer)this.numLeft.getValue();
        s.top = (Integer)this.numTop.getValue();
        s.right = (Integer)this.numRight.getValue();
        s.bottom = (Integer)this.numBottom.getValue();
        if (this.rRot0.isSelected()) {
            s.orientation = 0;
        } else if (this.rRot90.isSelected()) {
            s.orientation = 90;
        } else if (this.rRot270.isSelected()) {
            s.orientation = 270;
        }
        return s;
    }

    private void saveSettings() {
        try {
            this.settings.save(this.getSettings());
        }
        catch (IOException ex) {
            Logger.getLogger(LabelPrinterGui.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

