/*
 * Decompiled with CFR 0.152.
 */
package labelprinter;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import labelprinter.PrintSettings;

public class LabelPrinterService {
    public List<String> getPrinters() {
        return Arrays.asList(PrinterJob.lookupPrintServices()).stream().map(p -> p.getName()).collect(Collectors.toList());
    }

    public void print(PrintSettings s, final File f, int copies) throws PrinterException {
        Paper p = new Paper();
        p.setSize(LabelPrinterService.mmToUnit(s.width), LabelPrinterService.mmToUnit(s.height));
        p.setImageableArea(LabelPrinterService.mmToUnit(s.left), LabelPrinterService.mmToUnit(s.top), LabelPrinterService.mmToUnit(s.width - s.left - s.right), LabelPrinterService.mmToUnit(s.height - s.top - s.bottom));
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        PrinterJob pj = PrinterJob.getPrinterJob();
        PrintService printer = this.getPrinter(s.printer);
        pj.setPrintService(printer);
        PageFormat pf = pj.defaultPage();
        switch (s.orientation) {
            case 0: {
                pf.setOrientation(1);
                break;
            }
            case 90: {
                pf.setOrientation(0);
                break;
            }
            case 270: {
                pf.setOrientation(2);
            }
        }
        pf.setPaper(p);
        pj.setPrintable(new Printable(){

            @Override
            public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
                System.out.println("Printing on page " + LabelPrinterService.unitToMm(pf.getWidth()) + "x" + LabelPrinterService.unitToMm(pf.getHeight()) + " imageable size " + LabelPrinterService.unitToMm(pf.getImageableWidth()) + "x" + LabelPrinterService.unitToMm(pf.getImageableHeight()) + " top left " + LabelPrinterService.unitToMm(pf.getImageableX()) + "x" + LabelPrinterService.unitToMm(pf.getImageableY()) + " orientation " + pf.getOrientation());
                if (page != 0) {
                    return 1;
                }
                try {
                    BufferedImage img = ImageIO.read(f);
                    g.drawImage(img, (int)pf.getImageableX(), (int)pf.getImageableY(), (int)(pf.getImageableX() + pf.getImageableWidth()), (int)(pf.getImageableY() + pf.getImageableHeight()), 0, 0, img.getWidth(), img.getHeight(), null);
                }
                catch (IOException ex) {
                    Logger.getLogger(LabelPrinterService.class.getName()).log(Level.SEVERE, null, ex);
                }
                return 0;
            }
        }, pf);
        pj.setCopies(copies);
        pj.print(new HashPrintRequestAttributeSet());
    }

    public PrintService getPrinter(String printerName) {
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int i = 0; i < services.length; ++i) {
            if (!printerName.equals(services[i].getName())) continue;
            return services[i];
        }
        return null;
    }

    public PrintSettings getDefaultSettings(String printerName) {
        PrintSettings ps = new PrintSettings();
        ps.printer = printerName;
        try {
            PrinterJob pj = PrinterJob.getPrinterJob();
            PrintService printer = this.getPrinter(printerName);
            pj.setPrintService(printer);
            PageFormat pf = pj.defaultPage();
            ps.width = LabelPrinterService.unitToMm(pf.getWidth());
            ps.height = LabelPrinterService.unitToMm(pf.getHeight());
            ps.left = LabelPrinterService.unitToMm(pf.getImageableX());
            ps.right = LabelPrinterService.unitToMm(pf.getWidth() - pf.getImageableWidth() - pf.getImageableX());
            ps.top = LabelPrinterService.unitToMm(pf.getImageableY());
            ps.bottom = LabelPrinterService.unitToMm(pf.getHeight() - pf.getImageableHeight() - pf.getImageableY());
            switch (pf.getOrientation()) {
                case 0: {
                    ps.orientation = 0;
                    break;
                }
                case 1: {
                    ps.orientation = 90;
                    break;
                }
                case 2: {
                    ps.orientation = 270;
                }
            }
        }
        catch (PrinterException ex) {
            Logger.getLogger(LabelPrinterService.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ps;
    }

    private static double mmToUnit(double mm) {
        return mm * 72.0 / 25.4;
    }

    private static int unitToMm(double unit) {
        return (int)(unit * 25.4 / 72.0);
    }
}

