/*
 * Decompiled with CFR 0.152.
 */
package labelprinter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import labelprinter.PrintSettings;

public class PrintPreview
extends JPanel {
    private PrintSettings ps = null;
    private BufferedImage img = null;

    public void setPrintSettings(PrintSettings ps) {
        this.ps = ps;
    }

    public void setImage(BufferedImage img) {
        this.img = img;
    }

    public void setImage(File f) {
        if (f == null) {
            this.setImage((BufferedImage)null);
            return;
        }
        try {
            this.setImage(ImageIO.read(f));
        }
        catch (IOException ex) {
            Logger.getLogger(PrintPreview.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, (int)size.getWidth(), (int)size.getHeight());
        if (this.ps != null) {
            double scale = Math.max((double)this.ps.width / size.getWidth(), (double)this.ps.height / size.getHeight());
            int w = (int)((double)this.ps.width / scale);
            int h = (int)((double)this.ps.height / scale);
            int ox = (int)(size.getWidth() - (double)w) / 2;
            int oy = (int)(size.getHeight() - (double)h) / 2;
            g.setColor(Color.gray);
            g.fillRect(ox, oy, w, h);
            g.setColor(Color.white);
            w = (int)((double)(this.ps.width - this.ps.left - this.ps.right) / scale);
            h = (int)((double)(this.ps.height - this.ps.top - this.ps.bottom) / scale);
            g.fillRect(ox += (int)((double)this.ps.left / scale), oy += (int)((double)this.ps.top / scale), w, h);
            if (this.img != null) {
                g.drawImage(this.img, ox, oy, w + ox, h + oy, 0, 0, this.img.getWidth(), this.img.getHeight(), null);
            }
        }
    }
}

