/*
 * Decompiled with CFR 0.152.
 */
package labelprinter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import labelprinter.LabelPrinterService;
import labelprinter.PrintSettings;

public class PrintSettingsService {
    private final File settingsFile;
    private String defaultPrinter = null;
    private String defaultPath = null;
    private Map<String, PrintSettings> settingsMap = new HashMap<String, PrintSettings>();
    private final LabelPrinterService printService;

    public PrintSettingsService(File settingsFile, LabelPrinterService printService) {
        this.settingsFile = settingsFile;
        this.printService = printService;
    }

    public String getDefaultPrinter() {
        return this.defaultPrinter;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    public PrintSettings getSettings(String printer) {
        if (this.settingsMap.containsKey(printer)) {
            return this.settingsMap.get(printer);
        }
        PrintSettings s = this.printService.getDefaultSettings(printer);
        return s;
    }

    public void save(PrintSettings s) throws IOException {
        this.defaultPrinter = s.printer;
        this.settingsMap.put(s.printer, s);
        FileOutputStream fileOut = new FileOutputStream(this.settingsFile);
        ObjectOutputStream objectOut = new ObjectOutputStream(fileOut);
        objectOut.writeObject(this.settingsMap);
        objectOut.writeObject(this.defaultPrinter);
        objectOut.writeObject(this.defaultPath);
        objectOut.close();
    }

    public void load() throws IOException, ClassNotFoundException {
        ObjectInputStream os = new ObjectInputStream(new FileInputStream(this.settingsFile));
        this.settingsMap = (Map)os.readObject();
        this.defaultPrinter = (String)os.readObject();
        this.defaultPath = (String)os.readObject();
        os.close();
    }
}

